<?

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Asterisk Directory for Aastra SIP Phones R1.4.1 or better
#
# php source code
#
# Parses
#    - SIP users
#    - IAX users
#
# Warning
#    Location of Asterisk config files is set to "/etc/asterisk"
###################################################################################################

# Location of asterisk config files
$location = "/etc/asterisk/";

# Global Variables
$Server = "http://$SERVER_ADDR".$_SERVER['SCRIPT_NAME'];

# Init number of records
$index=0;

# Parse sip.conf
$sip_array=parse_ini_file($location."sip_additional.conf", true);
while ($v=current($sip_array))
	{
	if((isset($v['callerid'])) and (key($sip_array)!="register"))
		{
		$temp=$v['callerid'];
		$len=strlen($temp);
		$callerid=substr($temp,0,$len-(strlen(strrchr($temp, '<')))-1);
		$directory[] = "<Prompt>". $callerid."</Prompt>\n"."<URI>".key($sip_array)."</URI>\n"."<Selection>". key($sip_array)."&amp;name=".$callerid."</Selection>\n";
		$index++;
		}
	next($sip_array);
	}

# Parse iax.conf
$iax_array=parse_ini_file($location."iax.conf", true);
while($v=current($iax_array))
	{ 
	if(isset($v['name'])) 
		{
		$directory[]="<Prompt>".$v['name']."</Prompt>\n"."<URI>".key($iax_array)."</URI>\n";
		$index++;
		}
	next($iax_array);
	}

# Sort Directory
sort($directory);

# Retrieve last page
$last=intval($index/15);
if(($index-$last*15) != 0) $last++;

# Retrieve current page
$page=$_GET['page'];
if (empty($page)) $page=1;

# Display Page
$output ="<AastraIPPhoneTextMenu destroyOnExit=\"yes\">";
$output .= "<Title>Directory ($page/$last)</Title>\n";
$index=1;
foreach ($directory as $v) 
	{
	if(($index>=(($page-1)*15+1)) and ($index<=$page*15))
		{
  		$output .= "<MenuItem>\n";
  		$output .= $v;
  		$output .= "</MenuItem>\n";	
		}
	$index++;
	}

# Dial button
$output .= "<SoftKey index=\"1\">\n";
$output .= "<Label>Dial</Label>\n";
$output .= "<URI>SoftKey:Dial</URI>\n";
$output .= "</SoftKey>\n";

# Next button
if($page!=$last)
	{
	$next=$page+1;
	$output .= "<SoftKey index=\"5\">\n";
	$output .= "<Label>Next</Label>\n";
	$output .= "<URI>$Server?page=$next</URI>\n";
	$output .= "</SoftKey>\n";
	}

# Previous button
if($page!=1)
	{
	$previous=$page-1;
	$output .= "<SoftKey index=\"2\">\n";
	$output .= "<Label>Previous</Label>\n";
	$output .= "<URI>$Server?page=$previous</URI>\n";
	$output .= "</SoftKey>\n";
	}

# Exit Button
$output .= "<SoftKey index=\"6\">\n";
$output .= "<Label>Exit</Label>\n";
$output .= "<URI>SoftKey:Exit</URI>\n";
$output .= "</SoftKey>\n";

# End of the object
$output .= "</AastraIPPhoneTextMenu>\n";

# HTTP header and output
header("Content-Type: text/xml");
header("Content-Length: ".strlen($output));
echo $output;
?>

